/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.dispatch.actionControllers;

import com.aptana.configurations.processor.ConfigurationStatus;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.jetty.util.epl.ajax.JSON;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.dispatch.IBrowserNotificationConstants;
import com.aptana.portal.ui.dispatch.actionControllers.AbstractActionController;
import com.aptana.portal.ui.dispatch.actionControllers.ControllerAction;
import com.aptana.portal.ui.dispatch.actionControllers.Messages;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contextlaunching.LaunchingResourceManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchActionController
extends AbstractActionController {
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_MODE = "mode";
    private static final String ATTR_TYPE = "type";

    @ControllerAction
    public Object getLaunchTypes(Object attributes) {
        if (!this.containsMap(attributes)) {
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        Map attrMap = (Map)((Object[])attributes)[0];
        IProject project = this.getProject((String)attrMap.get(ATTR_PROJECT));
        if (project == null) {
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        String mode = this.getMode((String)attrMap.get(ATTR_MODE));
        if (mode == null) {
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        LaunchingResourceManager lrm = DebugUIPlugin.getDefault().getLaunchingResourceManager();
        List shortcutsForSelection = lrm.getShortcutsForSelection((IStructuredSelection)new StructuredSelection((Object)project), mode);
        HashMap<String, String> result = new HashMap<String, String>();
        if (CollectionsUtil.isEmpty((Collection)shortcutsForSelection)) {
            return JSON.toString(result);
        }
        for (LaunchShortcutExtension shortcut : shortcutsForSelection) {
            result.put(shortcut.getId(), shortcut.getLabel());
        }
        return JSON.toString(result);
    }

    @ControllerAction
    public Object launch(Object attributes) {
        if (!this.containsMap(attributes)) {
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        Map attrMap = (Map)((Object[])attributes)[0];
        IProject project = this.getProject((String)attrMap.get(ATTR_PROJECT));
        if (project == null) {
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        String mode = this.getMode((String)attrMap.get(ATTR_MODE));
        if (mode == null) {
            return IBrowserNotificationConstants.JSON_ERROR;
        }
        String type = (String)attrMap.get(ATTR_TYPE);
        if (StringUtil.isEmpty((String)type)) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception("LaunchActionController - missing type"));
        }
        LaunchingResourceManager lrm = DebugUIPlugin.getDefault().getLaunchingResourceManager();
        StructuredSelection projectSelection = new StructuredSelection((Object)project);
        List shortcutsForSelection = lrm.getShortcutsForSelection((IStructuredSelection)projectSelection, mode);
        for (LaunchShortcutExtension shortcut : shortcutsForSelection) {
            if (!type.equals(shortcut.getId())) continue;
            this.innerLaunch(shortcut, (ISelection)projectSelection, mode);
            return IBrowserNotificationConstants.JSON_OK;
        }
        return IBrowserNotificationConstants.JSON_ERROR;
    }

    private void innerLaunch(final LaunchShortcutExtension shortcut, final ISelection projectSelection, final String mode) {
        UIJob launchJob = new UIJob(Messages.LaunchActionController_launchingJob){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                shortcut.launch(projectSelection, mode);
                return Status.OK_STATUS;
            }
        };
        launchJob.schedule();
    }

    private String getMode(String mode) {
        if (StringUtil.isEmpty((String)mode)) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception("LaunchActionController - Missing launch mode"));
            return null;
        }
        if ("run".equals(mode = mode.toLowerCase().trim()) || "debug".equals(mode) || "profile".equals(mode)) {
            return mode;
        }
        IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception("LaunchActionController - Unknown mode: " + mode));
        return null;
    }

    private IProject getProject(String projectName) {
        if (StringUtil.isEmpty((String)projectName) && StringUtil.isEmpty((String)(projectName = InstanceScope.INSTANCE.getNode("com.aptana.portal.ui").get("recently_created_project", null)))) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception("LaunchActionController - Missing project name"));
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(projectName);
        if (resource == null) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(MessageFormat.format("LaunchActionController - Could not locate a project named ''{0}'' in the workspace", projectName)));
            return null;
        }
        IProject project = resource.getProject();
        if (!project.isAccessible()) {
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(MessageFormat.format("LaunchActionController - The project ''{0}'' is not accessible", project.getName())));
            return null;
        }
        return project;
    }

    private boolean containsMap(Object attributes) {
        if (attributes instanceof Object[]) {
            Object[] arr = (Object[])attributes;
            if (arr.length == 1) {
                if (arr[0] instanceof Map) {
                    return true;
                }
                IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception("Wrong argument type passed to LaunchActionController. Expected a Map."));
                return false;
            }
            String message = MessageFormat.format("Wrong argument count passed to LaunchActionController. Expected 1 and got {0}", arr.length);
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        } else {
            String message = MessageFormat.format("Wrong argument type passed to LaunchActionController. Expected Object[] and got {0}", attributes == null ? "null" : attributes.getClass().getName());
            IdeLog.logError((Plugin)PortalUIPlugin.getDefault(), (Throwable)new Exception(message));
        }
        return false;
    }

    public void configurationStateChanged(ConfigurationStatus status, Set<String> attributesChanged) {
    }
}

